//------------------------------------------------------------------/
// PB detection.mq4
// 
//------------------------------------------------------------------/
#property copyright "" 
#property link      ""

#property indicator_chart_window 
#property indicator_buffers 4
#property indicator_color1 Brown
#property indicator_color2 Brown
#property indicator_color3 Brown
#property indicator_color4 Brown

extern double Nose=0.0015;
extern double CloseToLeftEye=0.0005;
extern bool   MAFilter=true;
extern int    MAPeriod=3;
extern string MethodDescription="0:Smpl,1:Exp,2:Smoothed,3:Wght";
extern int    MAMethod=1;
extern string PriceDescription="0:Cl,1:Op,2:Hi,3:Lo,4:Med,5:Typ,6:W";
extern int    MAPrice=0;
extern double MADistanceToClose=0.0001;

double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];


int init() 
  {
   SetIndexStyle(0,DRAW_ARROW); 
   SetIndexArrow(0,111); 
   SetIndexBuffer(0,ExtMapBuffer1); 
   SetIndexEmptyValue(0,0.0);
   SetIndexStyle(1,DRAW_ARROW); 
   SetIndexArrow(1,111); 
   SetIndexBuffer(1,ExtMapBuffer2); 
   SetIndexEmptyValue(1,0.0);
   SetIndexStyle(2,DRAW_ARROW); 
   SetIndexArrow(2,111); 
   SetIndexBuffer(2,ExtMapBuffer3); 
   SetIndexEmptyValue(2,0.0);
   SetIndexStyle(3,DRAW_ARROW); 
   SetIndexArrow(3,111); 
   SetIndexBuffer(3,ExtMapBuffer4); 
   SetIndexEmptyValue(3,0.0);

   return(0);
  } 

int deinit() {
   }

  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   double mavalue,mahigh,malow;
   int limit;
   int    counted_bars=IndicatorCounted();
   
  //---- check for possible errors
   if(counted_bars<0) return(-1);
  //---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
  //---- main loop
     for(int i=0; i<limit; i++)
       {
         mavalue = iMA(NULL,0,MAPeriod,0,MAMethod,MAPrice,i);
         
         if (MAFilter) {
            if(High[i]>mavalue && Close[i]>mavalue+MADistanceToClose) mahigh=1; else mahigh=0;
            if(Low[i]<mavalue && Close[i]<mavalue-MADistanceToClose) malow=1; else malow=0;
         }
         else {
            mahigh=1;
            malow=1;         
         }
         
         if ((High[i]>High[i+1]+Nose)&&(Close[i]<(High[i+1]+CloseToLeftEye))&&(mahigh==1)) {
             ExtMapBuffer1[i]=Low[i];
             ExtMapBuffer3[i]=High[i];
         }
         
         
         if ((Low[i]<Low[i+1]-Nose)&&(Close[i]>(Low[i+1]-CloseToLeftEye))&&(malow==1)) {
             ExtMapBuffer2[i]=High[i];            
             ExtMapBuffer4[i]=Low[i];
         }
         
       }
  //---- done

//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+